/**
 * \file
 *
 * \brief Empty user application template
 *
 */

/**
 * \mainpage User Application template doxygen documentation
 *
 * \par Empty user application template
 *
 * Bare minimum empty user application template
 *
 * \par Content
 *
 * -# Include the ASF header files (through asf.h)
 * -# "Insert system clock initialization code here" comment
 * -# Minimal main function that starts with a call to board_init()
 * -# "Insert application code here" comment
 *
 */

/*
 * Include header files for all drivers that have been imported from
 * Atmel Software Framework (ASF).
 */
 /**
 * Support and FAQ: visit <a href="http://www.atmel.com/design-support/">Atmel Support</a>
 */
#include <asf.h>
#include <conf_board.h>
#include "LTC2600.h"

void console_open(bool enable);
int cdc_getstring(char *buf, int maxlen);
int cdc_getint(int maxlen);

int main (void)
{
	uint8_t c;
	uint8_t addr;
	uint16_t data;
	// Insert system clock initialization code here (sysclk_init()).

	sysclk_init();
	irq_initialize_vectors();

	stdio_usb_init();

	cpu_irq_enable();
	board_init();
	sleepmgr_init();
	
	LTC2600_init();

	// Insert application code here, after the board has been initialized.
	
	while(1)
	{
	
		if(udi_cdc_is_rx_ready())
		{
			c = udi_cdc_getc();
			udi_cdc_putc(c);
			switch(c)
			{
				case 13:
				case 'm':
						printf("\r\nM: Menue\r\n");
						printf("=================================\r\n");
						printf("0 - Send register to MPU-6050\r\n");
						printf("1 - Read register from MPU-6050\r\n");
						printf("2 - Read all register from MPU-6050\r\n");
						printf("3 - Show raw sensor values\r\n");
						printf("4 - Show pitch and roll\r\n");
						printf("5 - Show board state\r\n");
						printf("6 - Enable/Disable Measure Timer\r\n");
						printf("7 - Change Timer Interval\r\n");
						printf("8 - BT debug mode\r\n");
						printf("9 - Send BT cmd\r\n");
						printf("o - Send BT ATI1\r\n");
						printf("a,y - Main Throttle +,-\r\n");
						printf("t - Enter Test Mode\r\n");
						printf("d - Single Motor +,-\r\n");
						printf("i - show PID values\r\n");
				
						break;
				case '0':
						{
							uint8_t reg=0, data=0;
							printf("\r\nEnter register: ");
							reg = cdc_getint(5);
							printf("Enter data: ");
							data = cdc_getint(5);
						
							printf("\r\nWrite 0x%02X to register 0x%02X...", data, reg);
							printf("ready.\r\n");
						}
						break;
				case '1':
						{
							uint8_t reg=0, data=0;
							printf("\r\nEnter register: ");
							reg = cdc_getint(5);
					
							printf("\r\nRead register 0x%02X = ", reg);
							printf("0x%02X.\r\n", data);
						}
						break;
				case '2':
						break;
				case '3':
						break;
				case '6':
						break;
				

				case 'p':
						addr=0;
						data=0;
						printf("\r\nEnter register: ");
						addr = cdc_getint(5);
						printf("Enter Voltage(mV): ");
						data = cdc_getint(5);
						LTC2600_set(addr, LTC2600_CMD_WRITE, data);
						printf("Enter Currend (A): ");
						data = cdc_getint(5);
						LTC2600_set(addr+1, LTC2600_CMD_WRITE, data);

						break;
				default:
						printf_P(PSTR("\r\nNot Implemented!\r\n"));
						break;
			}
			printf_P(PSTR("\r\n> "));
		}	//USB
	}	//while(1)
}
void console_open(bool enable)
{
	printf_P(PSTR("ATXMEGA Board v1.0 Console\r\nPress 'm' for Menue"));
	printf_P(PSTR("\r\n> "));
	
	//usb_flag=1;
}

int cdc_getstring(char *buf, int maxlen)
{
	uint8_t val=0;
	uint8_t i=0;

	do
	{
		val = udi_cdc_getc();
		if(val==8)
		{
			if(i > 0)
			{
				i--;
				udi_cdc_putc(8);		// backspace
				udi_cdc_putc(32);		// space
				udi_cdc_putc(8);		// backspace
			}
		}
		else
		{
			if( (val > 31) && (val < 127) )
			{
				buf[i] = val;
				udi_cdc_putc(val);
				i++;
			}
		}
	}
	while( (val!=13) && (i < maxlen) );

	printf("\r\n");

	return i;
}

int cdc_getint(int maxlen)
{
	char buf[maxlen];
	int	 value=0;

	cdc_getstring(buf, maxlen);
	value = strtol(buf,NULL,0);
	
	return value;
}
